#version 330

// use gl_FrontFacing to know if the fragment is front or back facing

smooth in vec2 texCoord;
smooth in vec4 theColor;
out vec4 outputColor;

uniform sampler2D colorTexture;
uniform vec3 textColor;
uniform float textAlpha;
uniform vec3 shadowColor;
uniform vec2 shadowOffset;
uniform float shadowAlpha;

float sdftexture( float single, float smooth_factor )
{
    // ( x - 128 / 255 ) * ( 255 / 128 ) = ( x * ( 255 / 128 ) ) - 1
    // spread = 8.0
    // -8 exterior ; +8 interior
    float rescaled = ( single * 1.9921875 - 1.0 ) * 8.0;

    // 0 exterior ; 1 interior
    float rendered = smoothstep( - smooth_factor, smooth_factor, rescaled );

    return rendered;
}

void main()
{
    // gl_FragCoord.y : true window coordinates, not those of the viewport.

    float text = texture( colorTexture, texCoord ).r;
    if( shadowAlpha < 0.0 )
    {
        // Normal renderer.
        outputColor = vec4( textColor, textAlpha * text );
    }
    else
    {
        // SDF renderer.

        float shadow = texture( colorTexture, texCoord - shadowOffset ).r;

        float text_alpha = textAlpha * sdftexture( text, 0.6 );
        float shadow_alpha = shadowAlpha * sdftexture( shadow, 2.5 );

        // Consider printing first the shadow with shadow_alpha, then on top of that
        // the text with text_alpha.
        float magic = ( 1.0 - ( 1.0 - shadow_alpha ) * ( 1.0 - text_alpha ) );

        vec3 outputColorTmp = textColor * text_alpha + shadowColor * shadow_alpha * ( 1.0 - text_alpha );

        if( magic > 0.001 )
        {
            outputColor = vec4( outputColorTmp / magic, magic );
        }
        else
        {
            // Fully transparent.
            outputColor = vec4( 0.0 );
        }
    }
}
