#version 330

layout( location = 0 ) in vec4 position;
layout( location = 1 ) in vec4 color;
layout( location = 2 ) in vec2 texCoordPerVertex;

smooth out vec2 texCoord;
smooth out vec4 theColor;

layout( std140 ) uniform GlobalMatrices
{
    // Perspective.
    mat4 cameraToClipMatrix;
    float time;
};

void main()
{
    gl_Position = cameraToClipMatrix * position;

    texCoord = texCoordPerVertex;
    theColor = color ;
}
