#version 330

smooth in vec2 texCoord;
out vec4 outputColor;

// 24-bit RGB color ( GL_RGB )
uniform sampler2D renderedTexture;
// 24-bit float depth [ 0, 1 ] ( GL_DEPTH_COMPONENT24 )
uniform sampler2D renderedDepthTexture;

// vec2 ( GL_RG32F ):
// [ 0 ] = depth [ 0, 1 ] of the nearest front water polygon,
// [ 1 ] = depth of the nearest back water polygon
uniform sampler2D renderedWater;

const float zNear = 0.1;
// see also startClient - TODO make it configurable
const float zFar = 4096.0;

float depth2camera( float d )
{
	// [ 0, 1 ] -> [ -1, 1 ]
    float z_n = 2.0 * d - 1.0;
    float z_e = 2.0 * zNear * zFar / ( zFar + zNear - z_n * ( zFar - zNear ) );
	return z_e;
}

float fog_clamp( float dc, float d_min, float d_max )
{
	return ( clamp( dc, d_min, d_max) - d_min ) / ( d_max - d_min );
}

vec4 water( vec4 n, float delta_d )
{
	float water_fog = fog_clamp( delta_d, 0, 20 ) * 0.7 + 0.3;
	return mix( n, vec4( 0, 0, 0.5, 1 ), water_fog );
}

void main()
{
    // There is only one component: depth. Accessing it via r selector
	float d_opaque = texture( renderedDepthTexture, ( texCoord + 1 ) / 2 ).r;

    // TODO spherical distance instead of projected distance
	float dc_opaque = depth2camera( d_opaque );

    vec4 output_color_opaque = texture( renderedTexture, ( texCoord + 1 ) / 2 );

	//////////////////////////////////////
    // Water rendering

	vec4 water_depths = texture( renderedWater, ( texCoord + 1 ) / 2 );

	float d_water_front = water_depths.r;
	float d_water_back = water_depths.g;

	float dc_water_front = depth2camera( d_water_front );
	float dc_water_back = depth2camera( d_water_back );

	// dc_water_front < dc_opaque means there is some water in front of the opaque element
	// min(dc_water_back, dc_opaque) is useful if there is no back water polygon before the first opaque polygon

	outputColor = ( dc_water_front < dc_opaque) ?
        water( output_color_opaque, min( dc_water_back, dc_opaque ) - dc_water_front ) : output_color_opaque;

    // Note: gl_FragCoord.xy are true window coordinates, not those of the viewport
}
