#version 330

// data as they come in the VBO
// it is actually a vec3, see glVertexAttribPointer calls ; conversion to vec4 is done by GLSL
layout(location = 0) in vec4 position;
layout(location = 1) in vec4 color;
layout(location = 2) in vec2 texCoordPerVertex;

// output
smooth out vec2 texCoord;
smooth out vec4 theColor;

// Always identity.
// uniform mat4 modelToCameraMatrix;

layout(std140) uniform GlobalMatrices
{
    // perspective
    mat4 cameraToClipMatrix;
    float time;
};

void main()
{
    // Always identity.
    // vec4 position_in_camera = modelToCameraMatrix * position;
    vec4 position_in_camera = position;
    gl_Position = cameraToClipMatrix * position_in_camera;

    texCoord = texCoordPerVertex;
    theColor = color;
}
