#version 330

// data as they come in the VBO
// it is actually a vec3, see glVertexAttribPointer calls ; conversion to vec4 is done by GLSL
layout(location = 0) in vec4 position;
layout(location = 1) in vec4 color;
layout(location = 2) in vec2 texCoordPerVertex;

// output
smooth out vec2 texCoord;
smooth out vec4 theColor;
smooth out vec3 relativeCoord;

uniform mat4 modelToCameraMatrix;
uniform vec3 cameraPosition;

layout(std140) uniform GlobalMatrices
{
    // perspective
    mat4 cameraToClipMatrix;
    float time;
};

void main()
{

    // sin(time * 2 * M_PI) is a sine function with period of 10 seconds
    // sin(time * 5 * 2 * M_PI) is a sine function with period of 10/5 = 2 seconds

    vec4 position_in_camera = modelToCameraMatrix * position;
    gl_Position = cameraToClipMatrix * position_in_camera;

    texCoord = texCoordPerVertex;
    theColor = color;

    relativeCoord = position.xyz - cameraPosition.xyz;
}
