#version 330

smooth in vec2 texCoord;
smooth in vec4 theColor;

out vec4 outputColor;					// even if the output is a vec2, we should provide a vec4. Logical.

void main()
{
	// the depth for front facing polygons goes to the first component
	float front_facing = gl_FrontFacing ? gl_FragCoord.z : 1.0;

	// the depth for back facing polygons goes to the second component
	float back_facing  = gl_FrontFacing ? 1.0 : gl_FragCoord.z;

	// combined with MIN blending, we thus retrieve the closest front
    // facing depth and the closest back facing depth for each fragment

	outputColor = vec4(front_facing, back_facing, 0.0, 1.0);
	
	// gl_FragDepth
}
